#!/usr/bin/env ruby
require 'benchmark'

N = 1e6.to_i

class A
  attr_accessor :a, :b, :c
end

def t1
	m = A.new
	m.a = 34
	N.times{|er|
		m.b = m.a + 1
		m.c = m.a + m.b
	}
end

def t2
	m = A.new
	x = 34
	y = 0
	z = 0
	N.times{|er|
		y = x + 1
		z = x + y
	}
end

def t3
	m = A.new
	x = 34
	#y = 0
	#z = 0
	N.times{|er|
		y = x + 1
		z = x + y
	}
end

def t4
	m = A.new
	x = 1.3
	y = 0
	z = 0
	N.times{|er|
		y = Math::sin(x)
		z = Math::sqrt(y)
	}
end

Benchmark.bmbm do |x|
  x.report("t1") {t1}
  x.report("t2") {t2}
  x.report("t3") {t3}
  x.report("t4") {t4}
end

